IF OBJECT_ID ('P_PDV_VD_IT_META_VENDAS') IS NOT NULL
	BEGIN
			DROP PROCEDURE P_PDV_VD_IT_META_VENDAS
	END
GO
--EXEC P_PDV_VD_IT_META_VENDAS 1,1,2018,8,4,1,33,0,'2018-07-01','2018-07-31'
CREATE PROCEDURE P_PDV_VD_IT_META_VENDAS (@CD_EMP             INT,
										@CD_FILIAL          INT,
										@ANO                INT,
										@MES                INT,
										@PERC_CRESCIMENTO   MONEY,
										@CD_USU             INT,
										@PERC_LUCRATIVIDADE MONEY,
										@PERC_DESCONTO      MONEY=0,
										@DT_MES_BASE_INICIO DATETIME=NULL,
										@DT_MES_BASE_FIM    DATETIME = NULL)
WITH ENCRYPTION 
AS
		SET NOCOUNT ON;

		DECLARE @DTINI AS DATETIME
		DECLARE @DTFIM AS DATETIME
		DECLARE @DTFIMANOANTERIOR DATETIME
		DECLARE @DTINIANOANTERIOR DATETIME

		CREATE TABLE #RSVENDAS
			(
				 ORDEM                  INT IDENTITY (0, 1),
				 CD_EMP                 INT,
				 CD_FILIAL              INT,
				 DT_VD                  DATETIME,
				 DT_VD_META             DATETIME,
				 VLR_TOT_IT             MONEY,
				 VLR_DESC_IT            MONEY,
				 QTDE_VENDAS            MONEY,
				 QTDE_VENDAS_ITENS      MONEY,
				 VLR_TOT_IT_META        MONEY,
				 VLR_DESC_IT_META       MONEY,
				 QTDE_VENDAS_META       MONEY,
				 QTDE_VENDAS_ITENS_META MONEY
			)

		CREATE TABLE #RSVENDASMETAS
			(
				 ORDEM                  INT IDENTITY (0, 1),
				 CD_EMP                 INT,
				 CD_FILIAL              INT,
				 DT_VD                  DATETIME,
				 DT_VD_META             DATETIME,
				 DIASEMANA              VARCHAR(20),
				 VLR_TOT_IT             MONEY,
				 VLR_DESC_IT            MONEY,
				 QTDE_VENDAS            MONEY,
				 QTDE_VENDAS_ITENS      MONEY,
				 VLR_TOT_IT_META        MONEY,
				 VLR_DESC_IT_META       MONEY,
				 QTDE_VENDAS_META       MONEY,
				 QTDE_VENDAS_ITENS_META MONEY
			)

		DECLARE @DR INT
		DECLARE @DIASMES INT
		DECLARE @ANOPROC INT

		SET @ANOPROC=@ANO * 100 + @MES
		SET @DTINI= CONVERT(VARCHAR, @ANOPROC) + '01'
		SET @DTFIM= DATEADD(DAY, -1, DATEADD(MONTH, 1, @DTINI))

		SET @DR =DATEPART(WEEKDAY, @DTINI)
		SET @DR = CASE WHEN @DR = 1 THEN 8 - DATEPART(WEEKDAY, DATEADD(YEAR, -1, @DTINI))
							WHEN @DR = 2 THEN 2 - DATEPART(WEEKDAY, DATEADD(YEAR, -1, @DTINI))
							WHEN @DR = 3 THEN 3 - DATEPART(WEEKDAY, DATEADD(YEAR, -1, @DTINI))
							WHEN @DR = 4 THEN 4 - DATEPART(WEEKDAY, DATEADD(YEAR, -1, @DTINI))
							WHEN @DR = 5 THEN 5 - DATEPART(WEEKDAY, DATEADD(YEAR, -1, @DTINI))
							WHEN @DR = 6 THEN 6 - DATEPART(WEEKDAY, DATEADD(YEAR, -1, @DTINI))
							WHEN @DR = 7 THEN 7 - DATEPART(WEEKDAY, DATEADD(YEAR, -1, @DTINI))
							ELSE 0
							END
	    
		SET @DIASMES=DAY(DATEADD(DAY, -1, DATEADD(MONTH, 1, @DTINI)))
		IF @DT_MES_BASE_INICIO IS NULL 
		BEGIN
			SET @DTINIANOANTERIOR=DATEADD (DAY, @DR, DATEADD(YEAR, -1, @DTINI))
			SET @DTFIMANOANTERIOR=DATEADD (DAY, @DIASMES, DATEADD(DAY, @DR, DATEADD(YEAR, -1, @DTINI)))
		END
		BEGIN
			SET @DTINIANOANTERIOR=@DT_MES_BASE_INICIO
			SET @DTFIMANOANTERIOR=@DT_MES_BASE_FIM
		END

		IF @PERC_DESCONTO = 0
			BEGIN
					SET @PERC_DESCONTO=17
			END

		DECLARE @DIAS INT

		SET @DIAS=0

		WHILE( @DIAS <= @DIASMES )
			BEGIN
					INSERT INTO #RSVENDASMETAS
											(CD_EMP,
											 CD_FILIAL,
											 DT_VD,
											 DT_VD_META,
											 DIASEMANA,
											 VLR_TOT_IT,
											 VLR_DESC_IT,
											 QTDE_VENDAS,
											 QTDE_VENDAS_ITENS,
											 VLR_TOT_IT_META,
											 VLR_DESC_IT_META,
											 QTDE_VENDAS_META,
											 QTDE_VENDAS_ITENS_META)
					SELECT
						@CD_EMP
						,@CD_FILIAL
						,DATEADD (DAY, @DIAS, @DTINIANOANTERIOR)
						,NULL
						,NULL
						,0
						,0
						,0
						,0
						,0
						,0
						,0
						,0

					SET @DIAS=@DIAS + 1
			END

		INSERT INTO #RSVENDAS
		SELECT
			V.CD_EMP
			,V.CD_FILIAL
			,V.DT_VD
			,NULL
			,SUM(CASE WHEN ( I.TOT_IT - I.VLR_DESC_TOT_RAT ) > 0 THEN I.TOT_IT - I.VLR_DESC_TOT_RAT
					 ELSE 0
					 END)                                                                                                          AS VLR_TOT_IT
			,ROUND(SUM(( ( ( I.QT_IT * I.VLR_IT * I.TX_DESC ) + I.VLR_DESC_TOT_RAT ) / I.QT_IT ) / ( I.QT_IT * I.VLR_IT )), 2) AS VLR_DESC_IT
			,COUNT(DISTINCT V.CD_VD)                                                                                           AS QTDE_VENDAS
			,COUNT(I.CD_IT)                                                                                                    AS QTDE_VENDAS_ITENS
			,0
			,0
			,0
			,0
		FROM
			PDV_VD V
			INNER JOIN PDV_VD_IT I ON
				V.CD_EMP = I.CD_EMP AND
				V.CD_FILIAL = I.CD_FILIAL AND
				V.CD_VD = I.CD_VD AND
				V.DT_VD = I.DT_VD
		WHERE
			V.CD_EMP    = @CD_EMP AND
			V.ST_VD     = 0 AND
			I.ST_IT     = 1 AND
			V.DT_VD BETWEEN @DTINIANOANTERIOR AND @DTFIMANOANTERIOR AND
			V.CD_FILIAL = @CD_FILIAL
		GROUP  BY
			V.CD_EMP
			,V.CD_FILIAL
			,V.DT_VD


		DECLARE @VlrMetaVenda MONEY

		UPDATE #RSVENDAS
		SET    @VlrMetaVenda = VLR_TOT_IT
													 + ROUND(((VLR_TOT_IT*@PERC_CRESCIMENTO)/100.00), 2),
					 VLR_TOT_IT_META = @VlrMetaVenda,
					 VLR_DESC_IT_META = ROUND(( ( @VlrMetaVenda * ( @PERC_DESCONTO ) ) / 100.00 ), 2),
					 QTDE_VENDAS_META = QTDE_VENDAS
															+ CEILING(((QTDE_VENDAS*(@PERC_CRESCIMENTO*5))/100.00)),
					 QTDE_VENDAS_ITENS_META = QTDE_VENDAS_ITENS
																		+ CEILING(((QTDE_VENDAS_ITENS*(@PERC_CRESCIMENTO*8))/100.00))

		UPDATE M
		SET    M.DT_VD_META = DATEADD (DAY, M.ORDEM, @DTINI),
					 M.DIASEMANA = DATEPART(WEEKDAY, DATEADD (DAY, M.ORDEM, @DTINI)),
					 M.VLR_TOT_IT = ISNULL(V.VLR_TOT_IT, 0),
					 M.VLR_DESC_IT = ISNULL(V.VLR_DESC_IT, 0),
					 M.QTDE_VENDAS = ISNULL(V.QTDE_VENDAS, 0),
					 M.QTDE_VENDAS_ITENS = ISNULL(V.QTDE_VENDAS_ITENS, 0),
					 M.VLR_TOT_IT_META = ISNULL(V.VLR_TOT_IT_META, 0),
					 M.VLR_DESC_IT_META = ISNULL(V.VLR_DESC_IT_META, 0),
					 M.QTDE_VENDAS_META = ISNULL(V.QTDE_VENDAS_META, 0),
					 M.QTDE_VENDAS_ITENS_META = ISNULL(V.QTDE_VENDAS_ITENS_META, 0)
		FROM   #RSVENDASMETAS M
					 LEFT OUTER JOIN #RSVENDAS V ON
						 M.CD_EMP = V.CD_EMP AND
						 M.CD_FILIAL = V.CD_FILIAL AND
						 M.DT_VD = V.DT_VD

		DELETE FROM #RSVENDASMETAS
		WHERE  DT_VD_META > @DTFIM

		DECLARE @CDCTR INT
		DECLARE @CDMETAFILIAL INT

		SET @CDMETAFILIAL=ISNULL((SELECT TOP 1
																CD_META_FILIAL
															FROM
																EST_META_FILIAL
															WHERE
															 CD_EMP    = @CD_EMP AND
															 CD_FILIAL = @CD_FILIAL AND
															 MES_META  = @MES AND
															 ANO_META  = @ANO), 0)

		IF @CDMETAFILIAL > 0
			BEGIN
					DELETE FROM EST_META_FILIAL_CPL
					WHERE  CD_EMP         = @CD_EMP AND
								 CD_META_FILIAL = @CDMETAFILIAL

					DELETE FROM EST_META_FILIAL
					WHERE  CD_EMP         = @CD_EMP AND
								 CD_META_FILIAL = @CDMETAFILIAL
			END

		SET @CDCTR=ISNULL((SELECT MAX(CD_META_FILIAL) FROM EST_META_FILIAL WHERE CD_EMP =@CD_EMP), 0) + 1

		INSERT INTO EST_META_FILIAL
								(CD_EMP,
								 CD_META_FILIAL,
								 CD_FILIAL,
								 DS_META,
								 MES_META,
								 ANO_META,
								 VLR_VD,
								 VLR_DESC,
								 QTDE_CUPONS,
								 IT_CLI,
								 CD_USU,
								 DT_CAD,
								 PERC_LUCRATIVIDADE)
		SELECT
			CD_EMP
			,@CDCTR
			,CD_FILIAL
			,''
			,@MES
			,@ANO
			,SUM(VLR_TOT_IT_META)
			,SUM(VLR_DESC_IT_META)
			,SUM(QTDE_VENDAS_META)
			,SUM(QTDE_VENDAS_ITENS_META)
			,@CD_USU
			,CONVERT(CHAR(10), GETDATE(), 112)
			,@PERC_LUCRATIVIDADE
		FROM
			#RSVENDASMETAS
		GROUP  BY
			CD_EMP
			,CD_FILIAL

		INSERT INTO EST_META_FILIAL_CPL
								(CD_EMP,
								 CD_FILIAL,
								 CD_META_FILIAL,
								 DT_META,
								 VLR_VD,
								 VLR_DESC,
								 QTDE_CUPONS,
								 QTDE_ITENS)
		SELECT
			M.CD_EMP
			,M.CD_FILIAL
			,@CDCTR
			,M.DT_VD_META
			,M.VLR_TOT_IT_META
			,M.VLR_DESC_IT_META
			,M.QTDE_VENDAS_META
			,M.QTDE_VENDAS_ITENS_META
		FROM
			#RSVENDASMETAS M

		DROP TABLE #RSVENDAS;
		DROP TABLE #RSVENDASMETAS;
